/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core.configure;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.cdt.autotools.core.IAutotoolsOption;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.ConfigureMessages;
import org.eclipse.cdt.internal.autotools.core.configure.FlagConfigureOption;
import org.eclipse.cdt.internal.autotools.core.configure.IAConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IConfigureOption;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AutotoolsConfigurationManager
implements IResourceChangeListener {
    public static final String CFG_FILE_NAME = ".autotools";
    private static final String CFG_CANT_SAVE = "Configure.Error.NoProjectToSave";
    public static final String INVALID_AUTOTOOLS_PROJECT = "CfgOptions.Invalid.Project";
    public static final String INVALID_AUTOTOOLS_CONFIG_ID = "CfgOptions.Invalid.Config";
    private static AutotoolsConfigurationManager instance;
    private static Random rand;
    private boolean isSyncing;
    private static Map<String, Map<String, IAConfiguration>> configs;
    private static Map<String, Map<String, IAConfiguration>> tmpConfigs;

    static {
        rand = new Random();
    }

    private AutotoolsConfigurationManager() {
        configs = new HashMap<String, Map<String, IAConfiguration>>();
        tmpConfigs = new HashMap<String, Map<String, IAConfiguration>>();
        AutotoolsPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static AutotoolsConfigurationManager getInstance() {
        if (instance == null) {
            instance = new AutotoolsConfigurationManager();
        }
        return instance;
    }

    public synchronized IAConfiguration createDefaultConfiguration(IProject project, String id) {
        AutotoolsConfiguration cfg = new AutotoolsConfiguration(project, id);
        return cfg;
    }

    public synchronized IAConfiguration findCfg(IProject p, String id) {
        Map<String, IAConfiguration> cfgs = this.getConfigurations(p);
        return cfgs.get(id);
    }

    public synchronized IAConfiguration getConfiguration(IProject p, String cfgId) {
        return this.getConfiguration(p, cfgId, true);
    }

    public synchronized IAConfiguration getConfiguration(IProject p, String cfgId, boolean persist) {
        IAConfiguration cfg = this.findCfg(p, cfgId);
        if (cfg == null) {
            cfg = this.createDefaultConfiguration(p, cfgId);
            if (persist) {
                this.addConfiguration(p, cfg);
            }
        } else if (!persist) {
            cfg = cfg.copy(p);
        }
        return cfg;
    }

    public synchronized boolean isConfigurationAlreadySaved(IProject project, ICConfigurationDescription cfgd) {
        Map<String, IAConfiguration> cfgs = this.getSavedConfigs(project);
        if (cfgs != null) {
            return cfgs.get(cfgd.getId()) != null;
        }
        return false;
    }

    public synchronized void addConfiguration(IProject project, IAConfiguration cfg) {
        String projectName = project.getName();
        Map<String, IAConfiguration> cfgs = this.getSavedConfigs(project);
        if (cfgs == null) {
            cfgs = new HashMap<String, IAConfiguration>();
            configs.put(projectName, cfgs);
        }
        cfgs.put(cfg.getId(), cfg);
        this.saveConfigs(project);
    }

    public synchronized boolean isSyncing() {
        return this.isSyncing;
    }

    private synchronized void setSyncing(boolean value) {
        this.isSyncing = value;
    }

    public synchronized void syncConfigurations(IProject project) {
        this.setSyncing(true);
        this.clearTmpConfigurations(project);
        ICProjectDescription pd = CoreModel.getDefault().getProjectDescription(project);
        ICConfigurationDescription[] cfgs = pd.getConfigurations();
        HashMap<String, IAConfiguration> newCfgList = new HashMap<String, IAConfiguration>();
        int i = 0;
        while (i < cfgs.length) {
            cfgs[i].getConfigurationData();
            IAConfiguration acfg = this.getTmpConfiguration(project, cfgs[i]);
            newCfgList.put(cfgs[i].getId(), acfg);
            ++i;
        }
        this.setSyncing(false);
        this.clearTmpConfigurations(project);
        this.replaceProjectConfigurations(project, newCfgList);
    }

    public synchronized void replaceProjectConfigurations(IProject project, Map<String, IAConfiguration> cfgs) {
        String projectName = project.getName();
        configs.put(projectName, cfgs);
        this.saveConfigs(project);
    }

    public synchronized void replaceProjectConfigurations(IProject project, Map<String, IAConfiguration> cfgs, ICConfigurationDescription[] cfgds) {
        String projectName = project.getName();
        configs.put(projectName, cfgs);
        this.saveConfigs(project, cfgds);
    }

    private Map<String, IAConfiguration> getSavedConfigs(IProject project) {
        Map<String, IAConfiguration> list;
        block16: {
            String projectName = project.getName();
            list = configs.get(projectName);
            if (list != null) break block16;
            try {
                IPath fileLocation = project.getLocation().append(CFG_FILE_NAME);
                File dirFile = fileLocation.toFile();
                HashMap<String, IAConfiguration> cfgList = new HashMap<String, IAConfiguration>();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                if (!dirFile.exists()) break block16;
                Document d = db.parse(dirFile);
                Element e = d.getDocumentElement();
                NodeList cfgs = e.getElementsByTagName("configuration");
                int x = 0;
                while (x < cfgs.getLength()) {
                    block19: {
                        String cfgId;
                        Node n;
                        block18: {
                            Node nameNode;
                            block17: {
                                n = cfgs.item(x);
                                NamedNodeMap attrs = n.getAttributes();
                                nameNode = attrs.getNamedItem("name");
                                Node cfgIdNode = attrs.getNamedItem("id");
                                cfgId = null;
                                if (cfgIdNode == null) break block17;
                                cfgId = cfgIdNode.getNodeValue();
                                break block18;
                            }
                            if (nameNode == null) break block18;
                            String cfgName = nameNode.getNodeValue();
                            ICConfigurationDescription cfgd = CoreModel.getDefault().getProjectDescription(project).getConfigurationByName(cfgName);
                            if (cfgd == null) break block19;
                            cfgId = cfgd.getId();
                        }
                        AutotoolsConfiguration cfg = new AutotoolsConfiguration(project, cfgId);
                        NodeList l = n.getChildNodes();
                        int y = 0;
                        while (y < l.getLength()) {
                            IConfigureOption opt;
                            Node id;
                            NamedNodeMap optionAttrs;
                            Node child = l.item(y);
                            if (child.getNodeName().equals("option")) {
                                optionAttrs = child.getAttributes();
                                id = optionAttrs.getNamedItem("id");
                                Node value = optionAttrs.getNamedItem("value");
                                if (id != null && value != null) {
                                    cfg.setOption(id.getNodeValue(), value.getNodeValue());
                                }
                            } else if (child.getNodeName().equals("flag") && (opt = cfg.getOption((id = (optionAttrs = child.getAttributes()).getNamedItem("id")).getNodeValue())) instanceof FlagConfigureOption) {
                                NodeList l2 = child.getChildNodes();
                                int z = 0;
                                while (z < l2.getLength()) {
                                    Node flagChild = l2.item(z);
                                    if (flagChild.getNodeName().equals("flagvalue")) {
                                        NamedNodeMap optionAttrs2 = flagChild.getAttributes();
                                        Node id2 = optionAttrs2.getNamedItem("id");
                                        Node value = optionAttrs2.getNamedItem("value");
                                        cfg.setOption(id2.getNodeValue(), value.getNodeValue());
                                    }
                                    ++z;
                                }
                            }
                            ++y;
                        }
                        cfg.setDirty(false);
                        cfgList.put(cfg.getId(), cfg);
                    }
                    ++x;
                }
                if (cfgList.size() > 0) {
                    configs.put(projectName, cfgList);
                    list = cfgList;
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public synchronized IAConfiguration getTmpConfiguration(IProject p, ICConfigurationDescription cfgd) {
        Map<String, IAConfiguration> list = this.getTmpConfigs(p);
        IAConfiguration acfg = list.get(cfgd.getId());
        if (acfg != null) {
            return acfg;
        }
        IAConfiguration oldCfg = this.getConfiguration(p, cfgd.getId(), false);
        list.put(cfgd.getId(), oldCfg);
        return oldCfg;
    }

    public synchronized boolean cloneCfg(IProject p, String oldId, ICConfigurationDescription cfgd) {
        String newId;
        if (this.isConfigurationAlreadySaved(p, cfgd)) {
            return true;
        }
        Map<String, IAConfiguration> tmpList = this.getTmpConfigs(p);
        IAConfiguration cfg = tmpList.get(newId = cfgd.getId());
        if (cfg != null) {
            return false;
        }
        IAConfiguration oldCfg = null;
        Map<String, IAConfiguration> savedList = this.getSavedConfigs(p);
        if (savedList != null) {
            oldCfg = savedList.get(oldId);
        }
        if (oldCfg != null) {
            IAConfiguration newCfg = oldCfg.copy(p, cfgd.getId());
            tmpList.put(cfgd.getId(), newCfg);
            if (CoreModel.getDefault().getProjectDescription(p).getConfigurationById(newId) != null) {
                this.addConfiguration(p, newCfg);
                return true;
            }
        }
        return false;
    }

    private Map<String, IAConfiguration> getTmpConfigs(IProject p) {
        Map<String, IAConfiguration> tmpList = tmpConfigs.get(p.getName());
        if (tmpList == null) {
            tmpList = new HashMap<String, IAConfiguration>();
            tmpConfigs.put(p.getName(), tmpList);
        }
        return tmpList;
    }

    public synchronized void clearTmpConfigurations(IProject p) {
        tmpConfigs.remove(p.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveConfigs(IProject project) {
        IProject iProject = project;
        synchronized (iProject) {
            ICConfigurationDescription[] cfgds = CoreModel.getDefault().getProjectDescription(project).getConfigurations();
            this.saveConfigs(project, cfgds);
        }
    }

    private void syncNameField(ICConfigurationDescription cfgd) {
        IConfiguration icfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        String id = cfgd.getId();
        if (icfg != null) {
            IToolChain toolchain = icfg.getToolChain();
            ITool[] tools = toolchain.getTools();
            int j = 0;
            while (j < tools.length) {
                ITool tool = tools[j];
                if (tool.getName().equals("configure")) {
                    IOption option = tool.getOptionBySuperClassId("org.eclipse.linuxtools.cdt.autotools.core.option.configure.name");
                    ITool h = tool;
                    try {
                        IOption optionToSet = h.getOptionToSet(option, false);
                        optionToSet.setValue(id);
                    }
                    catch (BuildException buildException) {}
                }
                ++j;
            }
        }
    }

    private String xmlEscape(String value) {
        value = value.replaceAll("\\&", "&amp;");
        value = value.replaceAll("\\\"", "&quot;");
        value = value.replaceAll("\\'", "&apos;");
        value = value.replaceAll("\\<", "&lt;");
        value = value.replaceAll("\\>", "&gt;");
        return value;
    }

    private void saveConfigs(IProject project, ICConfigurationDescription[] cfgds) {
        try {
            String projectName = project.getName();
            IPath output = project.getLocation().append(CFG_FILE_NAME);
            File f = output.toFile();
            if (!f.exists()) {
                f.createNewFile();
            }
            if (f.exists()) {
                PrintWriter p = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                Map<String, IAConfiguration> cfgs = configs.get(projectName);
                p.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                p.println("<configurations>");
                AutotoolsConfiguration.Option[] optionList = AutotoolsConfiguration.getOptionList();
                this.setSyncing(true);
                int i = 0;
                while (i < cfgds.length) {
                    cfgds[i].getConfigurationData();
                    ++i;
                }
                this.setSyncing(false);
                i = 0;
                while (i < cfgds.length) {
                    ICConfigurationDescription cfgd = cfgds[i];
                    String id = cfgd.getId();
                    IAConfiguration cfg = cfgs.get(id);
                    if (cfg == null) {
                        cfg = this.createDefaultConfiguration(project, id);
                    }
                    p.println("<configuration id=\"" + cfg.getId() + "\">");
                    int j = 0;
                    while (j < optionList.length) {
                        AutotoolsConfiguration.Option option = optionList[j];
                        IConfigureOption opt = cfg.getOption(option.getName());
                        if (opt.isFlag()) {
                            p.println("<flag id=\"" + option.getName() + "\">");
                            FlagConfigureOption fco = (FlagConfigureOption)opt;
                            ArrayList<String> children = fco.getChildren();
                            int k = 0;
                            while (k < children.size()) {
                                String childName = children.get(k);
                                IConfigureOption childopt = cfg.getOption(childName);
                                p.println("<flagvalue id=\"" + childopt.getName() + "\" value=\"" + this.xmlEscape(childopt.getValue()) + "\"/>");
                                ++k;
                            }
                            p.println("</flag>");
                        } else if (!opt.isCategory() && !opt.isFlagValue()) {
                            p.println("<option id=\"" + option.getName() + "\" value=\"" + this.xmlEscape(opt.getValue()) + "\"/>");
                        }
                        ++j;
                    }
                    p.println("</configuration>");
                    this.syncNameField(cfgd);
                    ++i;
                }
                p.println("</configurations>");
                p.close();
            }
        }
        catch (IOException e) {
            AutotoolsPlugin.log(e);
        }
    }

    public synchronized void applyConfigs(String projectName, ICConfigurationDescription[] cfgds) {
        block15: {
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject res = (IProject)root.findMember(projectName, false);
                if (res == null || res.getType() != 4) {
                    AutotoolsPlugin.logErrorMessage(ConfigureMessages.getFormattedString(CFG_CANT_SAVE, new String[]{projectName}));
                    return;
                }
                IProject project = res;
                IPath output = project.getLocation().append(CFG_FILE_NAME);
                File f = output.toFile();
                if (!f.exists()) {
                    f.createNewFile();
                }
                if (!f.exists()) break block15;
                PrintWriter p = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                try {
                    Map<String, IAConfiguration> cfgs = this.getSavedConfigs(project);
                    if (cfgs == null) {
                        return;
                    }
                    p.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    p.println("<configurations>");
                    AutotoolsConfiguration.Option[] optionList = AutotoolsConfiguration.getOptionList();
                    HashSet<String> savedIds = new HashSet<String>();
                    this.setSyncing(true);
                    int x = 0;
                    while (x < cfgds.length) {
                        ICConfigurationDescription cfgd = cfgds[x];
                        cfgd.getConfigurationData();
                        String id = cfgd.getId();
                        savedIds.add(id);
                        IAConfiguration cfg = this.getTmpConfiguration(project, cfgd);
                        cfgs.put(id, cfg);
                        p.println("<configuration id=\"" + id + "\">");
                        int j = 0;
                        while (j < optionList.length) {
                            AutotoolsConfiguration.Option option = optionList[j];
                            IConfigureOption opt = cfg.getOption(option.getName());
                            if (!opt.isCategory()) {
                                p.println("<option id=\"" + option.getName() + "\" value=\"" + opt.getValue() + "\"/>");
                            }
                            ++j;
                        }
                        p.println("</configuration>");
                        this.syncNameField(cfgd);
                        ++x;
                    }
                    this.setSyncing(false);
                    for (String id : cfgs.keySet()) {
                        if (savedIds.contains(id)) continue;
                        IAConfiguration cfg = cfgs.get(id);
                        p.println("<configuration id=\"" + id + "\">");
                        int j = 0;
                        while (j < optionList.length) {
                            AutotoolsConfiguration.Option option = optionList[j];
                            IConfigureOption opt = cfg.getOption(option.getName());
                            if (!opt.isCategory()) {
                                p.println("<option id=\"" + option.getName() + "\" value=\"" + opt.getValue() + "\"/>");
                            }
                            ++j;
                        }
                        p.println("</configuration>");
                    }
                    p.println("</configurations>");
                }
                finally {
                    p.close();
                }
            }
            catch (IOException e) {
                AutotoolsPlugin.log(e);
            }
        }
    }

    public synchronized Map<String, IAConfiguration> getConfigurations(IProject project) {
        Map<String, IAConfiguration> list = this.getSavedConfigs(project);
        if (list == null) {
            list = new HashMap<String, IAConfiguration>();
            configs.put(project.getName(), list);
        }
        return list;
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        IResource res = event.getResource();
        if (!(res instanceof IProject)) {
            return;
        }
        String name = res.getName();
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        int kind = delta.getKind();
        if (configs.containsKey(name)) {
            int flags;
            if (kind == 2) {
                configs.remove(name);
                tmpConfigs.remove(name);
            } else if (kind == 4 && ((flags = delta.getFlags()) & 0x2000) != 0) {
                IPath path = delta.getMovedToPath();
                Map<String, IAConfiguration> cfgs = configs.get(name);
                String newName = path.lastSegment();
                configs.remove(name);
                configs.put(newName, cfgs);
                Map<String, IAConfiguration> tmpcfgs = tmpConfigs.get(name);
                tmpConfigs.remove(name);
                tmpConfigs.put(newName, tmpcfgs);
            }
        }
    }

    private String createDummyId() {
        String id;
        while (tmpConfigs.get(id = "TEMP_" + rand.nextInt()) != null) {
        }
        return id;
    }

    public synchronized Map<String, IAutotoolsOption> getAutotoolsCfgOptions(IProject project, String cfgId) throws CoreException {
        if (project == null || !project.hasNature("org.eclipse.cdt.autotools.core.autotoolsNatureV2")) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.autotools.core", ConfigureMessages.getString(INVALID_AUTOTOOLS_PROJECT)));
        }
        ICConfigurationDescription cfgd = CoreModel.getDefault().getProjectDescription(project).getConfigurationById(cfgId);
        IConfiguration icfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        if (icfg == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.autotools.core", ConfigureMessages.getString(INVALID_AUTOTOOLS_CONFIG_ID)));
        }
        IAConfiguration cfg = this.getConfiguration(project, cfgId);
        HashMap<String, IAutotoolsOption> options = new HashMap<String, IAutotoolsOption>();
        Map<String, IConfigureOption> cfgOptions = cfg.getOptions();
        IAConfiguration dummyCfg = this.createDefaultConfiguration(project, this.createDummyId());
        for (Map.Entry<String, IConfigureOption> entry : cfgOptions.entrySet()) {
            String name = entry.getKey();
            AutotoolsOption configOption = new AutotoolsOption(entry.getValue().copy((AutotoolsConfiguration)dummyCfg));
            options.put(name, configOption);
        }
        return options;
    }

    public synchronized void updateAutotoolCfgOptions(IProject project, String cfgId, Map<String, IAutotoolsOption> options) throws CoreException {
        if (project == null || !project.hasNature("org.eclipse.cdt.autotools.core.autotoolsNatureV2")) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.autotools.core", ConfigureMessages.getString(INVALID_AUTOTOOLS_PROJECT)));
        }
        IAConfiguration cfg = this.findCfg(project, cfgId);
        if (cfg == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.autotools.core", ConfigureMessages.getString(INVALID_AUTOTOOLS_CONFIG_ID)));
        }
        for (Map.Entry<String, IAutotoolsOption> entry : options.entrySet()) {
            String name = entry.getKey();
            IAutotoolsOption option = entry.getValue();
            IConfigureOption cfgOption = cfg.getOption(name);
            if (cfgOption == null) continue;
            cfgOption.setValue(option.getValue());
        }
        this.saveConfigs(project);
    }

    private class AutotoolsOption
    implements IAutotoolsOption {
        private IConfigureOption option;
        private static final String UNMODIFIABLE_CONFIG_OPTION = "CfgOptions.Unmodifiable.Option";

        public AutotoolsOption(IConfigureOption option) {
            this.option = option;
        }

        @Override
        public int getType() {
            return this.option.getType();
        }

        @Override
        public boolean canUpdate() {
            int type = this.getType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(String value) throws CoreException {
            if (!this.canUpdate()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.autotools.core", ConfigureMessages.getString(UNMODIFIABLE_CONFIG_OPTION)));
            }
            IConfigureOption iConfigureOption = this.option;
            synchronized (iConfigureOption) {
                this.option.setValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getValue() {
            IConfigureOption iConfigureOption = this.option;
            synchronized (iConfigureOption) {
                return this.option.getValue();
            }
        }
    }
}

