################################################################################
#
# xwayland
#
################################################################################

XWAYLAND_VERSION = 24.1.9
XWAYLAND_SOURCE = xwayland-$(XWAYLAND_VERSION).tar.xz
XWAYLAND_SITE = https://xorg.freedesktop.org/archive/individual/xserver
XWAYLAND_LICENSE = MIT
XWAYLAND_LICENSE_FILES = COPYING
XWAYLAND_CPE_ID_VENDOR = x.org
XWAYLAND_INSTALL_STAGING = YES
XWAYLAND_DEPENDENCIES = \
	libdrm \
	pixman \
	wayland \
	wayland-protocols \
	xlib_libxcvt \
	xlib_libXfont2 \
	xlib_libxkbfile \
	xlib_libXrandr \
	xlib_libxshmfence \
	xlib_xtrans \
	xorgproto
XWAYLAND_CONF_OPTS = \
	-Ddri3=true \
	-Dxvfb=false \
	-Ddefault_font_path=/usr/share/fonts/X11/ \
	-Ddtrace=false \
	-Ddocs=false

ifeq ($(BR2_PACKAGE_LIBEPOXY),y)
XWAYLAND_CONF_OPTS += -Dglamor=true
XWAYLAND_DEPENDENCIES += libepoxy
else
XWAYLAND_CONF_OPTS += -Dglamor=false
endif

ifeq ($(BR2_PACKAGE_HAS_LIBGL),y)
XWAYLAND_CONF_OPTS += -Dglx=true
XWAYLAND_DEPENDENCIES += libgl
else
XWAYLAND_CONF_OPTS += -Dglx=false
endif

ifeq ($(BR2_PACKAGE_XLIB_LIBXDMCP),y)
XWAYLAND_CONF_OPTS += \
	-Dxdmcp=true \
	-Dxdm-auth-1=true
XWAYLAND_DEPENDENCIES += xlib_libXdmcp
else
XWAYLAND_CONF_OPTS += \
	-Dxdmcp=false \
	-Dxdm-auth-1=false
endif

ifeq ($(BR2_PACKAGE_LIBTIRPC),y)
XWAYLAND_CONF_OPTS += -Dsecure-rpc=true
XWAYLAND_DEPENDENCIES += libtirpc
else
XWAYLAND_CONF_OPTS += -Dsecure-rpc=false
endif

ifeq ($(BR2_PACKAGE_LIBSELINUX)$(BR2_PACKAGE_AUDIT),yy)
XWAYLAND_CONF_OPTS += -Dxselinux=true
XWAYLAND_DEPENDENCIES += libselinux audit
else
XWAYLAND_CONF_OPTS += -Dxselinux=false
endif

# The order of the preferred SHA1 libraries should match used by meson.build.
ifeq ($(BR2_PACKAGE_LIBMD),y)
XWAYLAND_CONF_OPTS += -Dsha1=libmd
XWAYLAND_DEPENDENCIES += libmd
else ifeq ($(BR2_PACKAGE_LIBSHA1),y)
XWAYLAND_CONF_OPTS += -Dsha1=libsha1
XWAYLAND_DEPENDENCIES += libsha1
else ifeq ($(BR2_PACKAGE_NETTLE),y)
XWAYLAND_CONF_OPTS += -Dsha1=libnettle
XWAYLAND_DEPENDENCIES += nettle
else ifeq ($(BR2_PACKAGE_LIBGCRYPT),y)
XWAYLAND_CONF_OPTS += -Dsha1=libgcrypt
XWAYLAND_DEPENDENCIES += libgcrypt
else
XWAYLAND_CONF_OPTS += -Dsha1=libcrypto
XWAYLAND_DEPENDENCIES += openssl
endif

ifeq ($(BR2_PACKAGE_LIBUNWIND),y)
XWAYLAND_CONF_OPTS += -Dlibunwind=true
XWAYLAND_DEPENDENCIES += libunwind
else
XWAYLAND_CONF_OPTS += -Dlibunwind=false
endif

$(eval $(meson-package))
