################################################################################
#
# python-numpy
#
################################################################################

PYTHON_NUMPY_VERSION = 2.4.0
PYTHON_NUMPY_SOURCE = numpy-$(PYTHON_NUMPY_VERSION).tar.gz
PYTHON_NUMPY_SITE = https://files.pythonhosted.org/packages/a4/7a/6a3d14e205d292b738db449d0de649b373a59edb0d0b4493821d0a3e8718
PYTHON_NUMPY_LICENSE = BSD-3-Clause, MIT, Zlib
PYTHON_NUMPY_LICENSE_FILES = \
	LICENSE.txt \
	numpy/_build_utils/tempita/LICENSE.txt \
	numpy/_core/src/multiarray/dragon4.c \
	numpy/_core/include/numpy/libdivide/LICENSE.txt \
	numpy/linalg/lapack_lite/LICENSE.txt
PYTHON_NUMPY_CPE_ID_VENDOR = numpy
PYTHON_NUMPY_CPE_ID_PRODUCT = numpy

PYTHON_NUMPY_DEPENDENCIES = host-python-cython python3
HOST_PYTHON_NUMPY_DEPENDENCIES = host-python-cython host-python-meson-python

PYTHON_NUMPY_CONF_ENV += \
	_PYTHON_SYSCONFIGDATA_NAME=$(PKG_PYTHON_SYSCONFIGDATA_NAME) \
	PYTHONPATH="$(@D)/vendored-meson/meson:$(PYTHON3_PATH)"

PYTHON_NUMPY_NINJA_ENV += \
	PYTHONPATH="$(@D)/vendored-meson/meson:$(PYTHON3_PATH)"

ifeq ($(BR2_PACKAGE_LAPACK),y)
PYTHON_NUMPY_DEPENDENCIES += lapack
PYTHON_NUMPY_CONF_OPTS += -Dlapack=lapack
else
PYTHON_NUMPY_CONF_OPTS += -Dlapack=""
endif

ifeq ($(BR2_PACKAGE_OPENBLAS),y)
PYTHON_NUMPY_DEPENDENCIES += openblas
PYTHON_NUMPY_CONF_OPTS += -Dblas=openblas
else
PYTHON_NUMPY_CONF_OPTS += -Dblas=""
endif

# Generated by running this test program under QEMU:
# https://github.com/numpy/numpy/blob/v1.26.4/numpy/core/meson.build#L376-L455
ifeq ($(BR2_arcle),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_DOUBLE_LE
else ifeq ($(BR2_aarch64),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_QUAD_LE
else ifeq ($(BR2_aarch64_be),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_QUAD_BE
else ifeq ($(BR2_arm),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_DOUBLE_LE
else ifeq ($(BR2_armeb),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_DOUBLE_BE
else ifeq ($(BR2_i386),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = INTEL_EXTENDED_12_BYTES_LE
else ifeq ($(BR2_or1k),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_DOUBLE_BE
else ifeq ($(BR2_m68k),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = MOTOROLA_EXTENDED_12_BYTES_BE
else ifeq ($(BR2_mips),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_DOUBLE_BE
else ifeq ($(BR2_mipsel),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_DOUBLE_LE
else ifeq ($(BR2_powerpc),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IBM_DOUBLE_DOUBLE_BE
else ifeq ($(BR2_powerpc64),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IBM_DOUBLE_DOUBLE_BE
else ifeq ($(BR2_powerpc64le),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IBM_DOUBLE_DOUBLE_LE
else ifeq ($(BR2_riscv),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_QUAD_LE
else ifeq ($(BR2_sh4)$(BR2_sh4a),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_DOUBLE_LE
else ifeq ($(BR2_sh4eb)$(BR2_sh4aeb),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_DOUBLE_BE
else ifeq ($(BR2_sparc),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_DOUBLE_BE
else ifeq ($(BR2_sparc64),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = IEEE_QUAD_BE
else ifeq ($(BR2_x86_64),y)
PYTHON_NUMPY_LONGDOUBLE_FORMAT = INTEL_EXTENDED_16_BYTES_LE
endif

PYTHON_NUMPY_MESON_EXTRA_PROPERTIES = \
	longdouble_format='$(PYTHON_NUMPY_LONGDOUBLE_FORMAT)'

HOST_PYTHON_NUMPY_SETUP_TYPE = setuptools

HOST_PYTHON_NUMPY_CONF_ENV += \
	PYTHONPATH="$(@D)/vendored-meson/meson:$(HOST_DIR)/lib/python$(PYTHON3_VERSION_MAJOR)"

HOST_PYTHON_NUMPY_NINJA_ENV += \
	PYTHONPATH="$(@D)/vendored-meson/meson:$(HOST_DIR)/lib/python$(PYTHON3_VERSION_MAJOR)"

# Rather than add a host-blas or host-lapack dependencies, just use unoptimized,
# in-tree code.
HOST_PYTHON_NUMPY_CONF_OPTS = -Dblas="" -Dlapack=""

# Fixup the npymath.ini prefix path with actual target staging area where
# numpy core was built. Without this, target builds using numpy distutils
# extensions like python-scipy, python-numba cannot find -lnpymath since
# it uses host libraries (like libnpymath.a).
# So, the numpy distutils extension packages would explicitly link this
# config path for their package environment.
define PYTHON_NUMPY_FIXUP_NPY_PKG_CONFIG_FILES
	$(SED) '/^pkgdir=/d;/^prefix=/i pkgdir=$(PYTHON3_PATH)/site-packages/numpy/core' \
		$(PYTHON3_PATH)/site-packages/numpy/_core/lib/npy-pkg-config/npymath.ini
endef
PYTHON_NUMPY_POST_INSTALL_STAGING_HOOKS += PYTHON_NUMPY_FIXUP_NPY_PKG_CONFIG_FILES

# Some package may include few headers from NumPy, so let's install it
# in the staging area.
PYTHON_NUMPY_INSTALL_STAGING = YES

$(eval $(meson-package))
$(eval $(host-python-package))
