################################################################################
#
# lmbench
#
################################################################################

LMBENCH_VERSION = 8b3ddfa52ee4a886abe5af4550f404142966eb88
LMBENCH_SITE = $(call github,intel,lmbench,$(LMBENCH_VERSION))
LMBENCH_LICENSE = lmbench license (based on GPL-2.0)
LMBENCH_LICENSE_FILES = COPYING COPYING-2

LMBENCH_CFLAGS = $(TARGET_CFLAGS)

ifeq ($(BR2_PACKAGE_LIBTIRPC),y)
LMBENCH_DEPENDENCIES += host-pkgconf libtirpc
LMBENCH_CFLAGS += `$(PKG_CONFIG_HOST_BINARY) --cflags libtirpc`
LMBENCH_LDLIBS = `$(PKG_CONFIG_HOST_BINARY) --libs libtirpc`
endif

ifeq ($(BR2_TOOLCHAIN_HAS_GCC_BUG_101915),y)
LMBENCH_CFLAGS += -O0
endif

LMBENCH_POST_PATCH_HOOKS += UPDATE_CONFIG_HOOK

define LMBENCH_CONFIGURE_CMDS
	sed -i 's/CFLAGS=/CFLAGS+=/g' $(@D)/src/Makefile
	sed -i '/cd .*doc/d' $(@D)/src/Makefile
	sed -i '/include/d' $(@D)/src/Makefile
	touch $@
endef

# Note: there is a second stage 'make' invocation from the 'scripts/build'
# script. So the variables override below don't take direct effect in
# src/Makefile.
define LMBENCH_BUILD_CMDS
	$(TARGET_MAKE_ENV) $(MAKE) CFLAGS="$(LMBENCH_CFLAGS)" LDLIBS="$(LMBENCH_LDLIBS)" OS=$(ARCH) CC="$(TARGET_CC)" -C $(@D)/src
endef

define LMBENCH_INSTALL_TARGET_CMDS
	$(TARGET_MAKE_ENV) $(MAKE) CFLAGS="$(TARGET_CFLAGS)" OS=$(ARCH) CC="$(TARGET_CC)" BASE=$(TARGET_DIR)/usr -C $(@D)/src install
endef

$(eval $(generic-package))
