/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.properties;

import org.eclipse.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.ui.AbstractAutotoolsCPropertyTab;
import org.eclipse.cdt.internal.autotools.ui.properties.AutotoolsPropertyManager;
import org.eclipse.cdt.internal.autotools.ui.properties.AutotoolsPropertyMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AutotoolsEditorPropertyTab
extends AbstractAutotoolsCPropertyTab {
    protected Combo fACVersionCombo;
    protected Combo fAMVersionCombo;
    IProject project;

    private IProject getProject() {
        return this.page.getProject();
    }

    public boolean canBeVisible() {
        return true;
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        Composite composite = this.usercomp;
        GridData gd = new GridData(80);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.project = this.getProject();
        this.fACVersionCombo = new Combo(composite, 44);
        this.fACVersionCombo.setItems(AutotoolsPropertyConstants.fACVersions);
        this.fACVersionCombo.select(AutotoolsPropertyConstants.fACVersions.length - 1);
        gd = new GridData(34);
        this.fACVersionCombo.setLayoutData((Object)gd);
        Label label = new Label(composite, 16384);
        label.setText(AutotoolsPropertyMessages.getString("ACEditor.autoconfVersion"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAMVersionCombo = new Combo(composite, 44);
        this.fAMVersionCombo.setItems(AutotoolsPropertyConstants.fAMVersions);
        this.fAMVersionCombo.select(AutotoolsPropertyConstants.fAMVersions.length - 1);
        gd = new GridData(34);
        this.fAMVersionCombo.setLayoutData((Object)gd);
        Label label2 = new Label(composite, 16384);
        label2.setText(AutotoolsPropertyMessages.getString("ACEditor.automakeVersion"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label2.setLayoutData((Object)gd);
        this.initialize();
    }

    public void performOK() {
        String amVerSelected;
        String acVer = null;
        String amVer = null;
        boolean changed = false;
        try {
            acVer = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTOCONF_VERSION);
            amVer = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTOMAKE_VERSION);
        }
        catch (CoreException coreException) {
            acVer = "";
            amVer = "";
        }
        int index = this.fACVersionCombo.getSelectionIndex();
        String acVerSelected = this.fACVersionCombo.getItem(index);
        if (!acVerSelected.equals(acVer)) {
            changed = true;
            try {
                this.project.setPersistentProperty(AutotoolsPropertyConstants.AUTOCONF_VERSION, this.fACVersionCombo.getItem(index));
            }
            catch (CoreException coreException) {}
        }
        if (!(amVerSelected = this.fAMVersionCombo.getItem(index = this.fAMVersionCombo.getSelectionIndex())).equals(amVer)) {
            changed = true;
            try {
                this.project.setPersistentProperty(AutotoolsPropertyConstants.AUTOMAKE_VERSION, this.fAMVersionCombo.getItem(index));
            }
            catch (CoreException coreException) {}
        }
        if (changed) {
            AutotoolsPropertyManager.getDefault().notifyPropertyListeners(this.project, "AutoconfEditorMacroVersioning");
        }
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.performOK();
    }

    public void performDefaults() {
        String version = AutotoolsPlugin.getDefault().getPreferenceStore().getString("autoconf_version");
        String[] items = this.fACVersionCombo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(version)) break;
            ++i;
        }
        if (i >= items.length) {
            i = items.length - 1;
        }
        this.fACVersionCombo.select(i);
        version = AutotoolsPlugin.getDefault().getPreferenceStore().getString("automake_version");
        items = this.fAMVersionCombo.getItems();
        i = 0;
        while (i < items.length) {
            if (items[i].equals(version)) break;
            ++i;
        }
        if (i >= items.length) {
            i = items.length - 1;
        }
        this.fAMVersionCombo.select(i);
    }

    public void updateData(ICResourceDescription cfgd) {
    }

    public void updateButtons() {
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    private void initialize() {
        this.initializeACVersion();
        this.initializeAMVersion();
    }

    void initializeACVersion() {
        String version = "";
        try {
            version = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTOCONF_VERSION);
            if (version == null) {
                version = AutotoolsPlugin.getDefault().getPreferenceStore().getString("autoconf_version");
            }
        }
        catch (CoreException coreException) {}
        String[] items = this.fACVersionCombo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(version)) break;
            ++i;
        }
        if (i >= items.length) {
            i = items.length - 1;
        }
        this.fACVersionCombo.select(i);
    }

    void initializeAMVersion() {
        String version = "";
        try {
            version = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTOMAKE_VERSION);
            if (version == null) {
                version = AutotoolsPlugin.getDefault().getPreferenceStore().getString("automake_version");
            }
        }
        catch (CoreException coreException) {}
        String[] items = this.fAMVersionCombo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(version)) break;
            ++i;
        }
        if (i >= items.length) {
            i = items.length - 1;
        }
        this.fAMVersionCombo.select(i);
    }
}

