/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class MessageLine {
    private String fMessageText;
    private String fErrorText;
    private CLabel clabel;
    private Color fDefaultColor;
    private RGB fErrorRGB;
    protected Color fErrorColor;
    private static RGB fgErrorRGB = new RGB(200, 0, 0);

    public void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    public void clearMessage() {
        this.setMessage(null);
    }

    public String getErrorMessage() {
        return this.fErrorText;
    }

    public String getMessage() {
        return this.fMessageText;
    }

    public MessageLine(Composite parent, int style, RGB errorRGB) {
        this.clabel = new CLabel(parent, style);
        this.fDefaultColor = this.clabel.getForeground();
        this.fErrorRGB = errorRGB;
    }

    public MessageLine(Composite parent, int style) {
        this.clabel = new CLabel(parent, style);
        this.fDefaultColor = this.clabel.getForeground();
        this.fErrorRGB = fgErrorRGB;
    }

    public MessageLine(Composite parent) {
        this(parent, 16384);
    }

    public static void setErrorColor(RGB color) {
        fgErrorRGB = color;
    }

    public void setErrorMessage(String message) {
        this.fErrorText = message;
        if (message == null) {
            this.setMessage(this.fMessageText);
        } else {
            if (this.fErrorColor == null) {
                this.fErrorColor = new Color((Device)this.clabel.getDisplay(), this.fErrorRGB);
                this.clabel.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        MessageLine.this.fErrorColor.dispose();
                    }
                });
            }
            this.clabel.setForeground(this.fErrorColor);
            this.clabel.setText(message);
        }
    }

    public void setMessage(String message) {
        this.fMessageText = message;
        if (message == null) {
            message = "";
        }
        if (this.fErrorText == null) {
            this.clabel.setForeground(this.fDefaultColor);
            this.clabel.setText(message);
        }
    }

    public boolean isDisposed() {
        return this.clabel.isDisposed();
    }

    public void setAlignment(int left) {
        this.clabel.setAlignment(left);
    }

    public void setLayoutData(GridData gridData) {
        this.clabel.setLayoutData((Object)gridData);
    }
}

